/*
 * Decompiled with CFR 0.152.
 */
package com.github.mim1q.convenientdecor.mixin.entity;

import com.github.mim1q.convenientdecor.ConvenientDecor;
import com.github.mim1q.convenientdecor.init.ModItems;
import com.github.mim1q.convenientdecor.item.UmbrellaItem;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.Heightmap;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin
extends Entity {
    @Unique
    private int convenientdecor$umbrellaTimer = 0;

    @Shadow
    public abstract ItemStack m_21120_(InteractionHand var1);

    @Shadow
    public abstract void m_21008_(InteractionHand var1, ItemStack var2);

    public LivingEntityMixin(EntityType<?> type, Level world) {
        super(type, world);
    }

    @Unique
    private boolean convenientdecor$hasUmbrellaInHand(InteractionHand hand, boolean canBeBroken, boolean canBeFolded) {
        ItemStack stack = this.m_21120_(hand);
        Item item = stack.m_41720_();
        return !(!(item instanceof UmbrellaItem) || !canBeBroken && item == ModItems.BROKEN_UMBRELLA || !canBeFolded && UmbrellaItem.isFolded(stack));
    }

    @Unique
    private boolean convenientdecor$holdsUmbrella(boolean canBeBroken, boolean canBeFolded) {
        return this.convenientdecor$hasUmbrellaInHand(InteractionHand.MAIN_HAND, canBeBroken, canBeFolded) || this.convenientdecor$hasUmbrellaInHand(InteractionHand.OFF_HAND, canBeBroken, canBeFolded);
    }

    @Unique
    private void convenientdecor$tryBurnUmbrella(InteractionHand hand) {
        if (this.convenientdecor$hasUmbrellaInHand(hand, false, false)) {
            this.m_21008_(hand, ModItems.BROKEN_UMBRELLA.m_7968_());
        }
    }

    @Unique
    private boolean convenientdecor$onlyAirAbove() {
        for (int i = this.m_146904_() + 1; i <= this.m_9236_().m_151558_(); ++i) {
            if (this.m_9236_().m_46859_(this.m_20183_().m_175288_(i))) continue;
            return false;
        }
        return true;
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void tick(CallbackInfo ci) {
        if (!ConvenientDecor.CONFIG.features.umbrellaAttractsLightning) {
            return;
        }
        if (!this.m_9236_().f_46443_) {
            this.convenientdecor$umbrellaTimer = this.convenientdecor$holdsUmbrella(true, false) && this.m_9236_().m_46470_() && (double)this.m_9236_().m_5452_(Heightmap.Types.MOTION_BLOCKING, this.m_20183_()).m_123342_() <= this.m_20186_() && this.convenientdecor$onlyAirAbove() ? ++this.convenientdecor$umbrellaTimer : Math.min(0, this.convenientdecor$umbrellaTimer + 1);
            if (this.convenientdecor$umbrellaTimer > 1200 && this.f_19796_.m_188501_() < 0.05f) {
                this.convenientdecor$umbrellaTimer = -6000 - this.f_19796_.m_188503_(2400);
                LightningBolt lightning = (LightningBolt)EntityType.f_20465_.m_20615_(this.m_9236_());
                if (lightning != null) {
                    lightning.m_146884_(this.m_20182_());
                    this.m_9236_().m_7967_((Entity)lightning);
                    this.convenientdecor$tryBurnUmbrella(InteractionHand.MAIN_HAND);
                    this.convenientdecor$tryBurnUmbrella(InteractionHand.OFF_HAND);
                }
            }
        }
    }

    @ModifyVariable(method={"damage"}, at=@At(value="HEAD"), ordinal=0, argsOnly=true)
    private float modifyDamageAmount(float amount, DamageSource source) {
        if (!ConvenientDecor.CONFIG.features.umbrellaSlowsDownFalling) {
            return amount;
        }
        if (source == this.m_9236_().m_269111_().m_268989_() && this.convenientdecor$holdsUmbrella(false, false)) {
            return Math.min(0.25f * amount, 8.0f);
        }
        return amount;
    }

    @ModifyVariable(method={"travel"}, at=@At(value="STORE"), ordinal=0)
    private double modifyTravelGravity(double d) {
        if (!ConvenientDecor.CONFIG.features.umbrellaSlowsDownFalling) {
            return d;
        }
        if (this.convenientdecor$holdsUmbrella(false, false) && this.m_20184_().m_7098_() < 0.0) {
            return Math.min(d, (double)0.025f);
        }
        return d;
    }

    @Inject(method={"readCustomDataFromNbt"}, at={@At(value="TAIL")})
    private void readCustomDataFromNbt(CompoundTag nbt, CallbackInfo ci) {
        this.convenientdecor$umbrellaTimer = nbt.m_128451_("umbrellaTimer");
    }

    @Inject(method={"writeCustomDataToNbt"}, at={@At(value="TAIL")})
    private void writeCustomDataToNbt(CompoundTag nbt, CallbackInfo ci) {
        nbt.m_128405_("umbrellaTimer", this.convenientdecor$umbrellaTimer);
    }
}

